<?php
/**
 * Plugin Name: Address Change Notification
 * Description: Send a notification Email to the site admin whenever a customer changes their billing or shipping address in WooCommerce.
 * Author: Qodewire
 * Author URI: https://qodewire.com
 * Version: 1.0
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author    	Qodewire
 * @since		1.0
 */


/** Step 2 (from text above). */
add_action( 'admin_menu', 'address_change_notification_menu' );

/** Step 1. */
function address_change_notification_menu() {
	add_options_page( 'Address Change Notification Options', 'Address Change Notification', 'manage_options', 'address-change-notification', 'address_change_notification_options' );
}

/** Step 3. */
function address_change_notification_options() {
	if ( !current_user_can( 'manage_options' ) )  {
		wp_die( __( 'You do not have sufficient permissions to access this page.' ) );
	}
	echo '<div class="wrap">';
	include 'index.html';
	echo '</div>';
}


add_action( 'woocommerce_after_save_address_validation', 'dcwd_after_save_address', 10, 4 );
function dcwd_after_save_address( $user_id, $load_address, $address, $customer ) {
	//error_log( 'User ID: ' . $user_id );
	//error_log( 'Load address: ' . var_export( $load_address, true ) );
	//error_log( 'Address: ' . var_export( $address, true ) );
	//error_log( 'Customer: ' . var_export( $customer, true ) );

	
	// Retrieve any changes.
	$customer_original_info = new WC_Customer( $user_id );
	$address_changes = array();
	$existing_address = array();
	if ( 'billing' == $load_address ) {
		$address_changes = $customer->get_billing();
		$existing_changes = $customer_original_info->get_billing();
		//error_log( 'Billing Address: ' . var_export( $address_changes, true ) );
	}
	else {
		$address_changes = $customer->get_shipping();
		$existing_changes = $customer_original_info->get_shipping();
		//error_log( 'Shipping Address: ' . var_export( $address_changes, true ) );
	}
	
	// Create a list of the changes, with a friendly name for each field (e.g. 'Company Name' instead
	// of 'company_name') and the old and new values.
	$changes_text = array();
	foreach ( $address_changes as $field => $value ) {
		$changes_text[] = sprintf( '%s from "%s" to "%s"', $address[ $load_address . '_' . $field ][ 'label' ], $existing_changes[ $field ], $value );
	}
	
	if ( $changes_text ) {
		//error_log( 'Customer changed ' . ucwords( $load_address ). " address fields:\n" . implode( "\n", $changes_text ) );
		
		// Send the email to the admin.
		$subject = sprintf( 'Customer address change: %s (%d)', $customer->get_display_name(), $user_id );
		$body[] = sprintf( 'Customer %s (ID: %d) changed %s address fields.', $customer->get_display_name(), $user_id, $load_address );
		$body[] = '';
		$body[] = 'Changes:';
		$body[] = '- ' . implode( "\n- ", $changes_text );
		
		wp_mail( get_option( 'admin_email' ), $subject, implode( "\n", $body ) );
	}
	else {
		// It's possible to save the form without changing anything.
		error_log( 'No changes were made.' );
	}
}